<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Transaction extends Model 
{

    protected $table = 'Transaction';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('order_id', 'product_id', 'user_id');

    public function transactionOrder()
    {
        return $this->hasOne('App\Models\Order', 'order_id');
    }

    public function transactionUser()
    {
        return $this->hasMany('App\Models\User', 'user_id');
    }

}